function HappinessTaskCounter::onUpdate()
{
	%cnt=rsGetResourceCount($Resource::Happiness);
	if(%cnt <= 50)
	{
     echo("Happiness counter task triggered");
     TaskModifier.strMarkVertex("HappinessTasks", "HappinessTaskCounter", $TSV_CMPLETE);
 	}
}
function RandomHappinessTask::onEnter()
{

   %taskstring = "saloon gazebo fountain statue church";//string of Happiness boosting buildings
   %randomnum = mAbs(getRandom(0,4));
   %randomtask = getWord(%taskstring,%randomnum);
   
   %charlist = "";
   
   // Add male civs to string charlist
   %objList = tsCreateObjList();
   tsFindObjTypeOnMap("MaleCiv", "char", %objList);
   for(%index = 0; %index < %objList.getSize(); %index++)
   {
      %object = %objList.getID(%index);
      if(%object.getTeam() == "1")
      {
         %charlist = %charlist@" "@%object;
      }
   }
   tsDestroyObjList(%objList); // Destroy object list
   
   // Add male civs to string charlist
   %objList = tsCreateObjList();
   tsFindObjTypeOnMap("FemaleCiv", "char", %objList);
   for(%index = 0; %index < %objList.getSize(); %index++)
   {
      %object = %objList.getID(%index);
      if(%object.getTeam() == "1")
      {
         %charlist = %charlist@" "@%object;
      }
   }
   %charlist = ltrim(%charlist); // removes space in charlist string
   %civnumber = getWordCount(%charlist);
   // Pick random male or female civ. If no civ is found hero unit is used.
   %randomnum = mAbs(getRandom(0,%civnumber-1));
   if(%civnumber > 0)
   {
      %randomciv = getWord(%charlist,%randomnum);
   }
   else //string empty no civs
   {
      %randomciv = HeroCharacter.getID();
   }
   %dlgData = tsCreateTaskDlgData("Boost Town Happiness", true, false);
   tsAddTaskDialog("ID_"@%randomtask, %dlgData);
   tsSendTaskDlgMsg(%dlgData, %randomciv);
   tsDestroyTaskDlgData(%dlgData);
	TaskModifier.strMarkVertex("HappinessTasks", "HT_"@%randomtask, $TSV_AVAIL);
	TaskModifier.strMarkVertex("HappinessTasks", "RandomHappinessTask", $TSV_CMPLETE);
}
// Happiness Buildings
function HT_saloon::onEnter()
{
   TaskModifier.strMarkVertex("HappinessTasks", "HT_saloon", $TSV_CMPLETE);
}
function HT_saloonbuild::onExit()
{
   %dlgData = tsCreateTaskDlgData("Boost_Town_Morale", false, false);
   tsAddTaskDialog("ID_Salooncmpt", %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);

   %timer = new SLTimer()
   {
      time = 1;
   };
   %timer.notifyOnFire(resetHappinessCounter, %timer);
   %timer.building = "HT_saloon";
}
// Gazebo
function HT_gazebo::onEnter()
{
   TaskModifier.strMarkVertex("HappinessTasks", "HT_gazebo", $TSV_CMPLETE);
}
function HT_gazebobuild::onExit()
{
   %dlgData = tsCreateTaskDlgData("Boost_Town_Morale", false, false);
   tsAddTaskDialog("ID_Gazebocmpt", %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());

   %timer = new SLTimer()
   {
      time = 1;
   };
   %timer.notifyOnFire(resetHappinessCounter, %timer);
   %timer.building = "HT_gazebo";
}
function HT_statue::onEnter()
{
   TaskModifier.strMarkVertex("HappinessTasks", "HT_statue", $TSV_CMPLETE);
}
function HT_statuebuild::onExit()
{
   %dlgData = tsCreateTaskDlgData("Boost_Town_Morale", false, false);
   tsAddTaskDialog("ID_statuecmpt", %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);

   %timer = new SLTimer()
   {
      time = 1;
   };
   %timer.notifyOnFire(resetHappinessCounter, %timer);
   %timer.building = "HT_statue";
}
function HT_fountain::onEnter()
{
   TaskModifier.strMarkVertex("HappinessTasks", "HT_fountain", $TSV_CMPLETE);
}
function HT_fountainbuild::onExit()
{
   %dlgData = tsCreateTaskDlgData("Boost_Town_Morale", false, false);
   tsAddTaskDialog("ID_fountaincmpt", %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);

   %timer = new SLTimer()
   {
      time = 1;
   };
   %timer.notifyOnFire(resetHappinessCounter, %timer);
   %timer.building = "HT_fountain";
}
// Church
function HT_church::onEnter()
{
   TaskModifier.strMarkVertex("HappinessTasks", "HT_church", $TSV_CMPLETE);
}
function HT_churchbuild::onExit()
{
   %dlgData = tsCreateTaskDlgData("Boost_Town_Morale", false, false);
   tsAddTaskDialog("ID_churchcmpt", %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);

   %timer = new SLTimer()
   {
      time = 1;
   };
   %timer.notifyOnFire(resetHappinessCounter, %timer);
   %timer.building = "HT_fountain";
}

// Resets the Happiness Counter after 1 min
function SLTimer::resetHappinessCounter(%timer)
{
   TaskModifier.strResetVertex("HappinessTasks", %timer.building);
   TaskModifier.strResetVertex("HappinessTasks", "HappinessResetCounterDelay");
   TaskModifier.strMarkVertex("HappinessTasks", "HappinessResetCounterDelay", $TSV_AVAIL);
}
function HappinessResetCounterDelay::onExit(%this)
{
   TaskModifier.strResetVertex("HappinessTasks", "HappinessTaskCounter");
	TaskModifier.strMarkVertex("HappinessTasks", "HappinessTaskCounter", $TSV_AVAIL);
}

